#property link          "https://Indicatorszone.com/"
#property description   "Find More on IndicatorsZone.com"

 #property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Blue 
#property indicator_color2 Red
#property indicator_color3 Green
#property indicator_color4 Magenta
 
extern double twick_ratio=1.2;
extern double hightwick1 =10;
extern double hightwick2  =5;
extern double lowtwick1 =10;
extern double lowtwick2  =5;
extern bool    showDH = true,
               showBEOV = true;
extern bool    showDL = true;
extern bool    showIB4 = true;
  
   extern color txt=Chocolate;            

//---- buffers

double upArrow[];
double downArrow[];
double upArrow1[];
double downArrow1[];
string PatternText[ 5000];

datetime currBar;

int      digits,
         Pips;
double wick1;
double wick2;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() 
   {

//---- indicators
   
   ObjectsDeleteAll(0, OBJ_TEXT);
      
   SetIndexStyle(0,DRAW_ARROW, EMPTY);
   SetIndexArrow(0,234);
   SetIndexBuffer(0, downArrow);
      
   SetIndexStyle(1,DRAW_ARROW, EMPTY);
   SetIndexArrow(1,233);
   SetIndexBuffer(1, upArrow);
   
    SetIndexStyle(2,DRAW_ARROW, EMPTY);
   SetIndexArrow(2,234);
   SetIndexBuffer(2, downArrow1);
      
   SetIndexStyle(3,DRAW_ARROW, EMPTY);
   SetIndexArrow(3,233);
   SetIndexBuffer(3, upArrow1);  
   return(0);
   }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
   {
   double   Range,
            
            AvgRange,
              O1, O2, O3,
              C1, C2, C3,
             L1, L2, L3,
              H1, H2, H3;
            
   int      counter, 
            
            shift,
            shift1,
            shift2,
            shift3;
         
            
   string   pattern, 
            period;
            
   digits = MarketInfo(Symbol(),MODE_DIGITS);
      
   if(currBar == Time[0]) 
      {
      return(0);
      }
   
   currBar = Time[0];
   
   if(Period() >= 1440)
      Pips = 5;
   else
      Pips = 3;
   
   for (int j = 0; j < Bars; j++) 
      { 
      PatternText[j] = "pattern-" + j;
       
      }
      
   for (shift = 0; shift < Bars; shift++)
      {
      Range = 0;
      AvgRange = 0;
      
      for (counter = shift; counter <= shift+9; counter++) 
         {
         AvgRange = AvgRange + MathAbs(High[counter] - Low[counter]);
         }
         
      Range =  AvgRange/10;
      
      shift1 = shift + 1;
      shift2 = shift + 2;
      shift3 = shift + 3;
      
      O1 = NormalizeDouble(Open[shift1],digits);
      O2 = NormalizeDouble(Open[shift2],digits);
      O3 = NormalizeDouble(Open[shift3],digits);
      
      H1 = NormalizeDouble(High[shift1],digits);
      H2 = NormalizeDouble(High[shift2],digits);
      H3 = NormalizeDouble(High[shift3],digits);
      
      L1 = NormalizeDouble(Low[shift1],digits);
      L2 = NormalizeDouble(Low[shift2],digits);
      L3 = NormalizeDouble(Low[shift3],digits);
      
      C1 = NormalizeDouble(Close[shift1],digits);
      C2 = NormalizeDouble(Close[shift2],digits);
      C3 = NormalizeDouble(Close[shift3],digits);
    
  switch(Period()) 
     {
       case 1:     period = "M1";  break;
       case 5:     period = "M5";  break;
       case 15:    period = "M15"; break;
       case 30:    period = "M30"; break;      
       case 60:    period = "H1";  break;
       case 240:   period = "H4";  break;
       case 1440:  period = "D1";  break;
       case 10080: period = "W1";  break;
       case 43200: period = "MN";  break;
     }
            
   // Bearish Pattern 
      
      // Check for DBHLC - Double bar high  
      
      if(showDH && ((H1 == H2) || (H1 + Pips * Point == H2) || (H1 - Pips * Point == H2)) && (L1  <= L2))
         {
         ObjectCreate(PatternText[shift], OBJ_TEXT, 0, Time[shift1], High[shift1] + Range*0.7);
         ObjectSetText(PatternText[shift], "DH ", 8, "Arial", Chocolate);         
         downArrow[shift1] = High[shift1] + Range*0.25;
         }
       //  Bullish Pattern 
   
      //  - Double bar low  
      
      if(showDL && ((L1 == L2) || (L1 + Pips * Point == L2) || (L1 - Pips * Point == L2)) && (H1 >= H2))
         {
         ObjectCreate(PatternText[shift], OBJ_TEXT, 0, Time[shift1], Low[shift1] - Range*0.5);
         ObjectSetText(PatternText[shift], "DL", 8, "Arial", Chocolate);           
         upArrow[shift1] = Low[shift1] - Range*0.25;
         }
      //    - NO LOSS SELL SCALPING
      
      if(showBEOV && (H1 > H2) && (L1 > L2  ) &&   (H1-C1)>= hightwick1*Point&& (H2-C2)>=hightwick1*Point&&( (H1-C1) /(H2-C2) >=twick_ratio))
         {
         ObjectCreate(PatternText[shift], OBJ_TEXT, 0, Time[shift1], High[shift1] + Range*0.6);
         ObjectSetText(PatternText[shift], "NLS", 8, "Arial",Chocolate);            
         downArrow1[shift1] = High[shift1] + Range*0.25;
         }
         //    - NO LOSS BUY SCALPING
      
      if(showIB4 && (H1 < H2) && (L1 < L2  )   && (C1-L1)>= lowtwick1*Point&&(C2-L2)>=lowtwick2*Point&&( (C1-L1) /(C2-L2) >=twick_ratio))
         {
         ObjectCreate(PatternText[shift], OBJ_TEXT, 0, Time[shift1], Low[shift1] - Range*0.5 );
         ObjectSetText(PatternText[shift], "NLB", 8, "Arial",Chocolate);            
        upArrow1[shift1] = Low[shift1] - Range*0.25;
         }
       
      //  TMLTB - Two matching lows, trend breakout
      
     
         {
         
          
         }
      
      // Pin Bar pointing up
      
      
         {
          
         }
      
      // Key Reversal
      
       
         {
          
         }
      
      
   //  Bullish Patterns
   
       
      
      // BUOVB - Bullish outside vertical bar
      
      
         {
          
         }
      
      //  TMHTB - Two matching highs, trend breakout
      
       
         {
          
         }

      // Pin Bar pointing down
      
       
         {
          
         }
         
      // Key Reversal
      
      
      
               

   //  Non - directional patterns
   
      //  IB4 - Inside bar with range smaller than any of the 3 preceding Bars
      
      
      
      
         {
          

            {
             
            }
               
                  
//         if(upArrow[shift2] == EMPTY_VALUE || upArrow[shift2] == 0)
            {
             
            }
         }
      }
      
   return(0);
   }
int deinit() 
   {
   ObjectsDeleteAll(0, OBJ_TEXT);
    
   return(0);
   }
   //+----------------------------------